package com.ohaotian.plugin.es.annotation;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class DaoAutowiredBeanContainer {

    private List<DaoAutowiredBean> beans;

    private final ConcurrentMap<String, DaoAdapterFactory> factoryMap = new ConcurrentHashMap<>();

    public DaoAutowiredBeanContainer() {
        beans = new ArrayList<>();
    }

    public void addDaoAutowiredBean(DaoAutowiredBean bean) {
        beans.add(bean);
    }

    public static class DaoAutowiredBean {
        private final Object bean;
        private final Field daoField;

        public DaoAutowiredBean(Object bean, Field daoField) {
            this.bean = bean;
            this.daoField = daoField;
        }

        public Object getBean() {
            return bean;
        }

        public Field getDaoField() {
            return daoField;
        }
    }

    public List<DaoAutowiredBean> getBeans() {
        return beans;
    }

    public DaoAdapterFactory getOrCreate(String interFaceName) {
        if (!factoryMap.containsKey(interFaceName)) {
            DaoAdapterFactory factory = new DaoAdapterFactory();
            factoryMap.put(interFaceName, factory);
        }
        return factoryMap.get(interFaceName);
    }

    public ConcurrentMap<String, DaoAdapterFactory> getFactoryMap() {
        return factoryMap;
    }
}
