package com.ohaotian.plugin.es.builder.create;

import com.ohaotian.plugin.es.builder.Builder;

/**
 * @author pengys5
 */
public class SettingsBuilder implements Builder<SettingsBuilder.Setting> {

    private SettingsBuilder() {
    }

    private int numberOfShards;
    private int numberOfReplicas;
    private int refreshInterval;

    public static SettingsBuilder newBuilder() {
        return new SettingsBuilder();
    }

    public SettingsBuilder numberOfShards(int num) {
        this.numberOfShards = num;
        return this;
    }

    public SettingsBuilder numberOfReplicas(int num) {
        this.numberOfReplicas = num;
        return this;
    }

    public SettingsBuilder refreshInterval(int interval) {
        this.refreshInterval = interval;
        return this;
    }

    @Override public Setting build() {
        return new Setting(numberOfShards, numberOfReplicas, refreshInterval);
    }

    public class Setting {
        private final int numberOfShards;
        private final int numberOfReplicas;
        private final int refreshInterval;

        public Setting(int numberOfShards, int numberOfReplicas, int refreshInterval) {
            this.numberOfShards = numberOfShards;
            this.numberOfReplicas = numberOfReplicas;
            this.refreshInterval = refreshInterval;
        }

        public int getNumberOfShards() {
            return numberOfShards;
        }

        public int getNumberOfReplicas() {
            return numberOfReplicas;
        }

        public int getRefreshInterval() {
            return refreshInterval;
        }
    }
}
