package com.ohaotian.plugin.es.builder.delete;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
/**
 * @author pengys5
 */
public class DeleteBuilder implements Builder<DeleteBuilderItem> {

	private final DeleteRequestBuilder<DeleteBuilderItem> deleteRequestBuilder;
    private final String indexName;
    private final String id;
    private ColumnValueBuilder columnValueBuilder;

    private DeleteBuilder(DeleteRequestBuilder deleteRequestBuilder, String indexName, String id) {
        this.deleteRequestBuilder = deleteRequestBuilder;
        this.indexName = indexName;
        this.id = id;
    }

    public static DeleteBuilder newBuilder(DeleteRequestBuilder deleteRequestBuilder, String indexName, String id) {
        return new DeleteBuilder(deleteRequestBuilder, indexName, id);
    }

    public ColumnValueBuilder columnValueBuilder() {
        if (columnValueBuilder == null) {
            columnValueBuilder = ColumnValueBuilder.newBuilder();
        }
        return columnValueBuilder;
    }

    public void setColumnValueBuilder(ColumnValueBuilder columnValueBuilder) {
        this.columnValueBuilder = columnValueBuilder;
    }

    @Override public DeleteBuilderItem build() {
        return deleteRequestBuilder.build(indexName, id, columnValueBuilder);
    }
}
