package com.ohaotian.plugin.es.builder.delete;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.delete.EsDeleteRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.delete.OsDeleteRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class DeleteRequestBuilderAdapter implements Adapter<DeleteRequestBuilder> {

    private DaoInjector.DBType dbType;

    @Autowired
    private OsDeleteRequestBuilder osDeleteRequestBuilder;

    @Autowired
    private EsDeleteRequestBuilder esDeleteRequestBuilder;

    @Override
    public DeleteRequestBuilder requestBuilder() {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return esDeleteRequestBuilder;
        } else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return osDeleteRequestBuilder;
        } else {
            throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
        }
    }

    @Override
    public void setDBType(DaoInjector.DBType dbType) {
        this.dbType = dbType;
    }
}
