package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.search.EsSearchRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.search.OsSearchRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class SearchRequestBuilderAdapter implements Adapter<SearchRequestBuilder> {

    private DaoInjector.DBType dbType;

    @Autowired
    private OsSearchRequestBuilder osSearchRequestBuilder;

    @Autowired
    private EsSearchRequestBuilder esSearchRequestBuilder;

    @Override public SearchRequestBuilder requestBuilder() {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return esSearchRequestBuilder;
        } else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return osSearchRequestBuilder;
        }
        return null;
    }

    @Override public void setDBType(DaoInjector.DBType dbType) {
        this.dbType = dbType;
    }
}
