package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.search.sort.SortColumn;
import com.ohaotian.plugin.es.builder.search.sort.SearchSortMode;
import java.util.LinkedList;
import java.util.List;

/**
 * @author pengys5
 */
public class SortBuilder implements Builder<List<SortColumn>> {

    private List<SortColumn> columns;

    private SortBuilder() {
        columns = new LinkedList<>();
    }

    public static SortBuilder newBuilder() {
        return new SortBuilder();
    }

    public void addCol(String column, SearchSortMode searchSortMode) {
        columns.add(new SortColumn(column, searchSortMode));
    }

    @Override public List<SortColumn> build() {
        return columns;
    }
}
