package com.ohaotian.plugin.es.builder.search.filter;

/**
 * @author pengys5
 */
public class RangeFilterCondition implements FilterCondition {

    private String columnName;
    private Number value;
    private Operator operator;

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void lt(Number value) {
        this.value = value;
        this.operator = Operator.LT;
    }

    public void lte(Number value) {
        this.value = value;
        this.operator = Operator.LTE;
    }

    public void gt(Number value) {
        this.value = value;
        this.operator = Operator.GT;
    }

    public void gte(Number value) {
        this.value = value;
        this.operator = Operator.GTE;
    }

    public String getColumnName() {
        return columnName;
    }

    public Object getValue() {
        return value;
    }

    public Operator getOperator() {
        return operator;
    }

    public enum Operator {
        LT, LTE, GT, GTE
    }
}
