package com.ohaotian.plugin.es.builder.update;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho yudg
 * @time 2017年9月22日 下午10:46:18 */
public class UpdateBuilder implements Builder<UpdateBuilderItem> {

	private final UpdateRequestBuilder<UpdateBuilderItem> updateRequestBuilder;
	private final String								  indexName; 
	private final String								  id;
	private ColumnValueBuilder							  columnValueBuilder;

	private UpdateBuilder(UpdateRequestBuilder updateRequestBuilder, String indexName, String id) {
	        this.updateRequestBuilder = updateRequestBuilder;
	        this.indexName = indexName;
	        this.id = id;
	    }

	public static UpdateBuilder newBuilder(UpdateRequestBuilder updateRequestBuilder, String indexName, String id) {
		return new UpdateBuilder(updateRequestBuilder, indexName, id);
	}

	public ColumnValueBuilder columnValueBuilder() {
		if (columnValueBuilder == null) {
			columnValueBuilder = ColumnValueBuilder.newBuilder();
		}
		return columnValueBuilder;
	}

	public void setColumnValueBuilder(ColumnValueBuilder columnValueBuilder) {
		this.columnValueBuilder = columnValueBuilder;
	}

	@Override
	public UpdateBuilderItem build() {
		return updateRequestBuilder.build(indexName, id, columnValueBuilder);
	}
}
