package com.ohaotian.plugin.es.elasticsearch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.batch.BatchInsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.delete.DeleteRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.insert.InsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.plugin.es.core.ClientException;
import com.ohaotian.plugin.es.core.Installer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class ElasticSearchInstaller implements Installer {

    @Autowired
    private ElasticSearchConfigCheck configCheck;

    @Autowired
    private ElasticSearchClient client;

    @Autowired
    private DaoInjector daoInjector;

    @Autowired
    private InsertRequestBuilderAdapter insertRequestBuilderAdapter;
    
    @Autowired
    private BatchInsertRequestBuilderAdapter batchInsertRequestBuilderAdapter;

    @Autowired
    private DeleteRequestBuilderAdapter deleteRequestBuilderAdapter;

    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;

    @Override public boolean preInstall() {
        return configCheck.check();
    }

    @Override public void install() throws ClientException {
        client.initialize();
        daoInjector.inject(DaoInjector.DBType.ElasticSearch);
        insertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        batchInsertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        deleteRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        searchRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
    }
}
