package com.ohaotian.plugin.es.elasticsearch.builder.search;

import com.ohaotian.plugin.es.builder.search.query.BooleanQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.MatchQueryCondition;
import com.ohaotian.plugin.es.builder.search.query.QueryCondition;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

/**
 * @author pengys5
 */
public enum ElasticSearchQueryBuilder {
    INSTANCE;

    public QueryBuilder build(QueryCondition condition) {
        if (condition instanceof MatchQueryCondition) {
            MatchQueryCondition matchCondition = (MatchQueryCondition)condition;
            return new MatchQueryBuilder(matchCondition.getColumnName(), matchCondition.getValue());
        } else if (condition instanceof BooleanQueryCondition) {
            BooleanQueryCondition booleanCondition = (BooleanQueryCondition)condition;

            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            for (QueryCondition queryCondition : booleanCondition.getMust()) {
                boolQueryBuilder.must(build(queryCondition));
            }
            for (QueryCondition queryCondition : booleanCondition.getShould()) {
                boolQueryBuilder.should(build(queryCondition));
            }
            return boolQueryBuilder;
        } else {
            throw new RuntimeException("理论上不应该啊");
        }
    }
}