package com.ohaotian.plugin.es.opensearch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.batch.BatchDeleteRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.batch.BatchInsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.batch.BatchUpdateRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.delete.DeleteRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.insert.InsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.update.UpdateRequestBuilderAdapter;
import com.ohaotian.plugin.es.core.ClientException;
import com.ohaotian.plugin.es.core.Installer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class OpenSearchInstaller implements Installer {

    @Autowired
    private OpenSearchConfigCheck configCheck;

    @Autowired
    private OpenSearchClient client;

    @Autowired
    private DaoInjector daoInjector;

    @Autowired
    private InsertRequestBuilderAdapter insertRequestBuilderAdapter;
    
    @Autowired
    private BatchInsertRequestBuilderAdapter batchInsertRequestBuilderAdapter;

    @Autowired
    private DeleteRequestBuilderAdapter deleteRequestBuilderAdapter;

    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    
    @Autowired
    private BatchDeleteRequestBuilderAdapter batchDeleteRequestBuilderAdapter;
    
    @Autowired
    private UpdateRequestBuilderAdapter updateRequestBuilderAdapter;
    
    @Autowired
    private BatchUpdateRequestBuilderAdapter batchUpdateRequestBuilderAdapter;

    @Override public boolean preInstall() {
        return configCheck.check();
    }

    @Override public void install() throws ClientException {
        client.initialize();
        daoInjector.inject(DaoInjector.DBType.OpenSearch);
        insertRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        batchInsertRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        deleteRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        searchRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        batchDeleteRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        updateRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
        batchUpdateRequestBuilderAdapter.setDBType(DaoInjector.DBType.OpenSearch);
    }
}
