package com.ohaotian.plugin.es.opensearch.builder.search;

import com.ohaotian.plugin.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.FilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.RangeFilterCondition;

/**
 * @author pengys5
 */
public enum OpenSearchFilterBuilder {
	INSTANCE;

	public String build(FilterCondition condition) {
		if (condition instanceof MatchFilterCondition) {
			MatchFilterCondition matchCondition = (MatchFilterCondition) condition;
			return matchCondition.getColumnName() + "=" + matchCondition.getValue();
		} else if (condition instanceof BooleanFilterCondition) {
			BooleanFilterCondition booleanCondition = (BooleanFilterCondition) condition;

			StringBuilder boolConditionStr = new StringBuilder();
			boolConditionStr.append("(");

			if (booleanCondition.getMust().size() > 0) {
				boolConditionStr.append("(");
				boolean firstMust = true;
				for (FilterCondition filterCondition : booleanCondition.getMust()) {
					if (!firstMust) {
						boolConditionStr.append(" AND ");
					}
					boolConditionStr.append(build(filterCondition));
					firstMust = false;
				}
				boolConditionStr.append(")");
			}

			if (booleanCondition.getShould().size() > 0) {
				if (booleanCondition.getMust().size() > 0) {
					boolConditionStr.append(" OR ");
				}

				boolConditionStr.append("(");
				boolean firstShould = true;
				for (FilterCondition filterCondition : booleanCondition.getShould()) {
					if (!firstShould) {
						boolConditionStr.append(" OR ");
					}
					boolConditionStr.append(build(filterCondition));
					firstShould = false;
				}
				boolConditionStr.append(")");
			}

			boolConditionStr.append(")");

			return boolConditionStr.toString();
		} else if (condition instanceof RangeFilterCondition) {
			RangeFilterCondition rangeCondition = (RangeFilterCondition) condition;

			StringBuilder rangeConditionStr = new StringBuilder();
			if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.GT)) {
				rangeConditionStr.append(rangeCondition.getColumnName() + ">" + rangeCondition.getValue());
			} else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.GTE)) {
				rangeConditionStr.append(rangeCondition.getColumnName() + ">=" + rangeCondition.getValue());
			} else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.LT)) {
				rangeConditionStr.append(rangeCondition.getColumnName() + "<" + rangeCondition.getValue());
			} else if (rangeCondition.getOperator().equals(RangeFilterCondition.Operator.LTE)) {
				rangeConditionStr.append(rangeCondition.getColumnName() + "<=" + rangeCondition.getValue());
			}
			return rangeConditionStr.toString();
		} else {
			throw new RuntimeException("理论上不应该啊" + condition.getClass().getName());
		}
	}
}