/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.annotation;

import com.ohaotian.plugin.es.annotation.DaoAutowired;
import com.ohaotian.plugin.es.annotation.DaoAutowiredBeanContainer;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchDAO;
import com.ohaotian.plugin.es.opensearch.OpenSearchDAO;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class BeanPostProcessorListener
implements BeanPostProcessor {
    private final Logger logger = LogManager.getLogger(BeanPostProcessorListener.class);
    @Autowired
    private DaoAutowiredBeanContainer beanContainer;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Field[] fields;
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            DaoAutowired daoAutowired = field.getAnnotation(DaoAutowired.class);
            if (daoAutowired == null) continue;
            this.beanContainer.addDaoAutowiredBean(new DaoAutowiredBeanContainer.DaoAutowiredBean(bean, field));
            this.logger.debug("\u53d1\u73b0\u5305\u542bDaoAutowired\u5c5e\u6027\u6ce8\u89e3\u7684\u7c7b\uff1a{}, \u5c5e\u6027\u540d: {}", (Object)bean.getClass().getName(), (Object)field.getName());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        block3: {
            block2: {
                if (!(bean instanceof ElasticSearchDAO)) break block2;
                for (Class<?> beanClass : bean.getClass().getInterfaces()) {
                    this.logger.debug("\u53d1\u73b0\u5b9e\u73b0\u4e86ElasticSearchDAO\u63a5\u53e3\u7684DAO\u88c5\u8f7d\u5b8c\u6210\uff0c\u5c06\u5176\u6dfb\u52a0\u5230Container\u4e2d,\u63a5\u53e3\u540d: {}", (Object)beanClass.getName());
                    this.beanContainer.getOrCreate(beanClass.getName()).setEsDao((ElasticSearchDAO)bean);
                }
                break block3;
            }
            if (!(bean instanceof OpenSearchDAO)) break block3;
            for (Class<?> beanClass : bean.getClass().getInterfaces()) {
                this.logger.debug("\u53d1\u73b0\u5b9e\u73b0\u4e86OpenSearchDAO\u63a5\u53e3\u7684DAO\u88c5\u8f7d\u5b8c\u6210\uff0c\u5c06\u5176\u6dfb\u52a0\u5230Container\u4e2d,\u63a5\u53e3\u540d: {}", (Object)beanClass.getName());
                this.beanContainer.getOrCreate(beanClass.getName()).setOsDao((OpenSearchDAO)bean);
            }
        }
        return bean;
    }
}

