package com.ohaotian.plugin.es.builder.batch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.batch.EsBatchDeleteRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.batch.OsBatchDeleteRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author yudg
 */
@Component
public class BatchDeleteRequestBuilderAdapter implements Adapter<BatchDeleteRequestBuilder> {

    private DaoInjector.DBType dbType;

    @Autowired
    private OsBatchDeleteRequestBuilder osBatchDeleteRequestBuilder;

    @Autowired
    private EsBatchDeleteRequestBuilder esBatchDeleteRequestBuilder;

    @Override public void setDBType(DaoInjector.DBType dbType) {
        this.dbType = dbType;
    }

    @Override public BatchDeleteRequestBuilder requestBuilder() {
        if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
            return esBatchDeleteRequestBuilder;
        } else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
            return osBatchDeleteRequestBuilder;
        } else {
            throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
        }
    }
}
