package com.ohaotian.plugin.es.builder.create;

import com.ohaotian.plugin.es.builder.Builder;

/**
 * @author pengys5
 */
public class CreateBuilder implements Builder<String> {

    private final CreateRequestBuilder createRequestBuilder;
    private final String indexName;
    private SettingsBuilder settingsBuilder;
    private ColumnsBuilder columnsBuilder;

    private CreateBuilder(CreateRequestBuilder createRequestBuilder, String indexName) {
        this.createRequestBuilder = createRequestBuilder;
        this.indexName = indexName;
    }

    public static CreateBuilder newBuilder(CreateRequestBuilder createRequestBuilder, String indexName) {
        return new CreateBuilder(createRequestBuilder, indexName);
    }

    public SettingsBuilder settingsBuilder() {
        if (settingsBuilder == null) {
            settingsBuilder = SettingsBuilder.newBuilder();
        }
        return settingsBuilder;
    }

    public void setSettingsBuilder(SettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public ColumnsBuilder columnsBuilder() {
        if (columnsBuilder == null) {
            columnsBuilder = ColumnsBuilder.newBuilder();
        }
        return columnsBuilder;
    }

    public void setColumnsBuilder(ColumnsBuilder columnsBuilder) {
        this.columnsBuilder = columnsBuilder;
    }

    @Override public String build() {
        return createRequestBuilder.build(indexName, settingsBuilder, columnsBuilder);
    }
}
