package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.builder.Builder;
import java.util.LinkedList;
import java.util.List;

/**
 * @author pengys5
 */
public class AggregateBuilder implements Builder<List<AggregateBuilder.AggregateColumn>> {

    private List<AggregateColumn> aggColumn;

    private AggregateBuilder() {
        aggColumn = new LinkedList<>();
    }

    public static AggregateBuilder newBuilder() {
        return new AggregateBuilder();
    }

    public AggregateColumn setGroupId(String columnName) {
        AggregateColumn aggregateColumn = new AggregateColumn(columnName, false);
        aggColumn.add(aggregateColumn);
        return aggregateColumn;
    }

    public AggregateColumn setNestedColName(String columnName) {
        AggregateColumn aggregateColumn = new AggregateColumn(columnName, true);
        aggColumn.add(aggregateColumn);
        return aggregateColumn;
    }

    @Override public List<AggregateColumn> build() {
        return this.aggColumn;
    }

    public class AggregateColumn {
        private final String name;
        private final boolean isNested;
        private final List<AggregateFunction> functions;
        private FilterBuilder filterBuilder;

        public AggregateColumn(String name, boolean isNested) {
            this.name = name;
            this.isNested = isNested;
            this.functions = new LinkedList<>();
        }

        public FilterBuilder filterBuilder() {
            if (filterBuilder == null) {
                filterBuilder = FilterBuilder.newBuilder();
            }
            return filterBuilder;
        }

        public String getName() {
            return name;
        }

        public boolean isNested() {
            return isNested;
        }

        public List<AggregateFunction> getFunctions() {
            return functions;
        }

        public AggregateColumn max(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.MAX);
            functions.add(function);
            return this;
        }

        public AggregateColumn min(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.MIN);
            functions.add(function);
            return this;
        }

        public AggregateColumn sum(String columnName) {
            AggregateFunction function = new AggregateFunction(columnName, FuncName.SUM);
            functions.add(function);
            return this;
        }

        public AggregateColumn count() {
            AggregateFunction function = new AggregateFunction(null, FuncName.COUNT);
            functions.add(function);
            return this;
        }
    }

    public class AggregateFunction {
        private final String columnName;
        private final FuncName funcName;

        public AggregateFunction(String columnName, FuncName funcName) {
            this.columnName = columnName;
            this.funcName = funcName;
        }

        public String getColumnName() {
            return columnName;
        }

        public FuncName getFuncName() {
            return funcName;
        }
    }

    public enum FuncName {
        SUM, MAX, MIN, COUNT
    }
}
