package com.ohaotian.plugin.es.builder.update;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.Adapter;
import com.ohaotian.plugin.es.elasticsearch.builder.update.EsUpdateRequestBuilder;
import com.ohaotian.plugin.es.opensearch.builder.update.OsUpdateRequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho yudg
 * @time 2017年9月22日 下午10:58:09 */
@Component
public class UpdateRequestBuilderAdapter implements Adapter<UpdateRequestBuilder> {

	private DaoInjector.DBType	   dbType;

	@Autowired
	private OsUpdateRequestBuilder osUpdateRequestBuilder;

	@Autowired
	private EsUpdateRequestBuilder esUpdateRequestBuilder;

	@Override
	public UpdateRequestBuilder requestBuilder() {
		if (DaoInjector.DBType.ElasticSearch.equals(dbType)) {
			return esUpdateRequestBuilder;
		}
		else if (DaoInjector.DBType.OpenSearch.equals(dbType)) {
			return osUpdateRequestBuilder;
		}
		else {
			throw new RuntimeException("启动的数据库类型未找到，请检查数据库配置");
		}
	}

	@Override
	public void setDBType(DaoInjector.DBType dbType) {
		this.dbType = dbType;
	}
}
