package com.ohaotian.plugin.es.builder.insert;

import com.ohaotian.plugin.es.builder.Builder;

/**
 * @author pengys5
 */
public class InsertBuilder implements Builder<InsertBuilderItem> {

    private final InsertRequestBuilder<InsertBuilderItem> insertRequestBuilder;
    private final String indexName;
    private final String id;
    private ColumnValueBuilder columnValueBuilder;

    private InsertBuilder(InsertRequestBuilder insertRequestBuilder, String indexName, String id) {
        this.insertRequestBuilder = insertRequestBuilder;
        this.indexName = indexName;
        this.id = id;
    }

    public static InsertBuilder newBuilder(InsertRequestBuilder insertRequestBuilder, String indexName, String id) {
        return new InsertBuilder(insertRequestBuilder, indexName, id);
    }

    public ColumnValueBuilder columnValueBuilder() {
        if (columnValueBuilder == null) {
            columnValueBuilder = ColumnValueBuilder.newBuilder();
        }
        return columnValueBuilder;
    }

    public void setColumnValueBuilder(ColumnValueBuilder columnValueBuilder) {
        this.columnValueBuilder = columnValueBuilder;
    }

    @Override public InsertBuilderItem build() {
        return insertRequestBuilder.build(indexName, id, columnValueBuilder);
    }
}
