package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.builder.Builder;
import java.util.LinkedList;
import java.util.List;

/**
 * @author pengys5
 */
public class FetchBuilder implements Builder<List<String>> {

    private final List<String> columns;

    private FetchBuilder() {
        columns = new LinkedList<>();
    }

    public static FetchBuilder newBuilder() {
        return new FetchBuilder();
    }

    public FetchBuilder addCol(String column) {
        columns.add(column);
        return this;
    }

    @Override public List<String> build() {
        return columns;
    }
}
