package com.ohaotian.plugin.es.builder.search;

import com.ohaotian.plugin.es.builder.Builder;
import com.ohaotian.plugin.es.builder.search.result.Result;
import org.springframework.util.StringUtils;

/** @author pengys5 */
public class SearchBuilder implements Builder<Result> {

	private SearchBuilder(SearchRequestBuilder searchRequestBuilder) {
		this.searchRequestBuilder = searchRequestBuilder;
	}

	private String					   indexName;
	private int						   from;
	private int						   size;
	private QueryBuilder			   queryBuilder;
	private FilterBuilder			   filterBuilder;
	private FetchBuilder			   fetchBuilder;
	private SortBuilder				   sortBuilder;
	private AggregateBuilder		   aggregateBuilder;
	private final SearchRequestBuilder searchRequestBuilder;
	private RankBuilder				   rankBuilder;
	private String					   kvpairs;

	public static SearchBuilder newBuilder(SearchRequestBuilder searchRequestBuilder) {
		return new SearchBuilder(searchRequestBuilder);
	}

	public SearchBuilder setIndexName(String indexName) {
		this.indexName = indexName;
		return this;
	}

	public SearchBuilder setFrom(int from) {
		this.from = from;
		return this;
	}

	public SearchBuilder setSize(int size) {
		this.size = size;
		return this;
	}

	public QueryBuilder queryBuilder() {
		if (queryBuilder == null) {
			queryBuilder = QueryBuilder.newBuilder();
		}
		return queryBuilder;
	}

	public void setQueryBuilder(QueryBuilder queryBuilder) {
		this.queryBuilder = queryBuilder;
	}

	public FilterBuilder filterBuilder() {
		if (filterBuilder == null) {
			filterBuilder = FilterBuilder.newBuilder();
		}
		return filterBuilder;
	}

	public void setFilterBuilder(FilterBuilder filterBuilder) {
		this.filterBuilder = filterBuilder;
	}

	public FetchBuilder fetchBuilder() {
		if (fetchBuilder == null) {
			fetchBuilder = FetchBuilder.newBuilder();
		}
		return fetchBuilder;
	}

	public void setSortBuilder(SortBuilder sortBuilder) {
		this.sortBuilder = sortBuilder;
	}

	public SortBuilder sortBuilder() {
		if (sortBuilder == null) {
			sortBuilder = SortBuilder.newBuilder();
		}
		return sortBuilder;
	}

	public void setFetchBuilder(FetchBuilder fetchBuilder) {
		this.fetchBuilder = fetchBuilder;
	}

	public AggregateBuilder aggregateBuilder() {
		if (aggregateBuilder == null) {
			aggregateBuilder = AggregateBuilder.newBuilder();
		}
		return aggregateBuilder;
	}

	public void setAggregateBuilder(AggregateBuilder aggregateBuilder) {
		this.aggregateBuilder = aggregateBuilder;
	}

	public void setRankBuilder(RankBuilder rankBuilder) {
		this.rankBuilder = rankBuilder;
	}

	public RankBuilder rankBuilder() {
		if (rankBuilder == null) {
			rankBuilder = RankBuilder.newRankBuilder();
		}
		return rankBuilder;
	}

	@Override
	public Result build() {
		if (StringUtils.isEmpty(indexName)) {
			throw new RuntimeException("需要设置index name，通过SearchBuilder.setIndexName方法设置");
		}
		Result result = searchRequestBuilder.build(indexName, from, size, queryBuilder, filterBuilder, fetchBuilder, sortBuilder, aggregateBuilder, rankBuilder,kvpairs);
		return result;
	}

	
	public void setKvpairs(String kvpairs) {
		this.kvpairs = kvpairs;
	}
}
