package com.ohaotian.plugin.es.opensearch;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.SearcherClient;
import com.aliyun.opensearch.sdk.generated.OpenSearch;
import com.ohaotian.plugin.es.core.Client;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author pengys5
 */
@Component
public class OpenSearchClient implements Client {
    private final Logger logger = LogManager.getLogger(OpenSearchClient.class);

    private com.aliyun.opensearch.OpenSearchClient client;

    @Autowired
    private OpenSearchConfig config;

    @Override public void initialize() {
        OpenSearch openSearch = new OpenSearch(config.getAccesskey(), config.getSecret(), config.getHost());
        client = new com.aliyun.opensearch.OpenSearchClient(openSearch);
    }

    public SearcherClient createSearchClient() {
        return new SearcherClient(client);
    }

    public DocumentClient createDocumentClient() {
        return new DocumentClient(client);
    }
}
