/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.elasticsearch;

import com.ohaotian.plugin.es.annotation.DaoInjector;
import com.ohaotian.plugin.es.builder.batch.BatchInsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.batch.BatchUpdateRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.delete.DeleteRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.insert.InsertRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.search.SearchRequestBuilderAdapter;
import com.ohaotian.plugin.es.builder.update.UpdateRequestBuilderAdapter;
import com.ohaotian.plugin.es.core.ClientException;
import com.ohaotian.plugin.es.core.Installer;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchConfigCheck;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchInstaller
implements Installer {
    @Autowired
    private ElasticSearchConfigCheck configCheck;
    @Autowired
    private ElasticSearchClient client;
    @Autowired
    private DaoInjector daoInjector;
    @Autowired
    private InsertRequestBuilderAdapter insertRequestBuilderAdapter;
    @Autowired
    private BatchInsertRequestBuilderAdapter batchInsertRequestBuilderAdapter;
    @Autowired
    private DeleteRequestBuilderAdapter deleteRequestBuilderAdapter;
    @Autowired
    private SearchRequestBuilderAdapter searchRequestBuilderAdapter;
    @Autowired
    private UpdateRequestBuilderAdapter updateRequestBuilderAdapter;
    @Autowired
    private BatchUpdateRequestBuilderAdapter batchUpdateRequestBuilderAdapter;

    @Override
    public boolean preInstall() {
        return this.configCheck.check();
    }

    @Override
    public void install() throws ClientException {
        this.client.initialize();
        this.daoInjector.inject(DaoInjector.DBType.ElasticSearch);
        this.insertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.batchInsertRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.deleteRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.searchRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.updateRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
        this.batchUpdateRequestBuilderAdapter.setDBType(DaoInjector.DBType.ElasticSearch);
    }
}

