/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.elasticsearch.builder.batch;

import com.ohaotian.plugin.es.builder.batch.BatchUpdateRequestBuilder;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import com.ohaotian.plugin.es.elasticsearch.builder.update.EsUpdateRequestBuilder;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsBatchUpdateRequestBuilder
implements BatchUpdateRequestBuilder<EsUpdateRequestBuilder.EsUpdateBuilderItem> {
    private final Logger logger = LogManager.getLogger(EsBatchUpdateRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public void bulk(Collection<EsUpdateRequestBuilder.EsUpdateBuilderItem> builders) {
        BulkRequestBuilder bulkRequestBuilder = this.client.createBulkRequestBuilder();
        for (EsUpdateRequestBuilder.EsUpdateBuilderItem item : builders) {
            bulkRequestBuilder.add(item.getUpdateRequestBuilder());
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.get();
        if (bulkResponse.hasFailures()) {
            throw new IllegalStateException(bulkResponse.buildFailureMessage());
        }
    }
}

