/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.elasticsearch.builder.update;

import com.ohaotian.plugin.es.builder.insert.ColumnValueBuilder;
import com.ohaotian.plugin.es.builder.schema.DataType;
import com.ohaotian.plugin.es.builder.schema.Field;
import com.ohaotian.plugin.es.builder.schema.Nested;
import com.ohaotian.plugin.es.builder.update.UpdateBuilderItem;
import com.ohaotian.plugin.es.builder.update.UpdateRequestBuilder;
import com.ohaotian.plugin.es.elasticsearch.ElasticSearchClient;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.update.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EsUpdateRequestBuilder
implements UpdateRequestBuilder<EsUpdateBuilderItem> {
    private final Logger logger = LogManager.getLogger(EsUpdateRequestBuilder.class);
    @Autowired
    private ElasticSearchClient client;

    @Override
    public EsUpdateBuilderItem build(String tableName, String id, ColumnValueBuilder columnValueBuilder) {
        org.elasticsearch.action.update.UpdateRequestBuilder updateRequestBuilder = this.client.updateRequestBuilder();
        updateRequestBuilder.setIndex(tableName);
        updateRequestBuilder.setType("default");
        updateRequestBuilder.setId(id);
        LinkedHashMap<String, Object> source = new LinkedHashMap<String, Object>();
        Object fields = columnValueBuilder.build();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (DataType.Double.equals((Object)field.getDateType()) || DataType.Integer.equals((Object)field.getDateType()) || DataType.Long.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (DataType.Text.equals((Object)field.getDateType())) {
                source.put(field.getName(), field.getValue());
                continue;
            }
            if (!DataType.Nested.equals((Object)field.getDateType())) continue;
            Nested nested = (Nested)field.getValue();
            LinkedList nestedList = new LinkedList();
            for (String nestedRow : nested.getRows()) {
                LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
                valueMap.put("nested_id", nestedRow);
                nestedList.add(valueMap);
            }
            source.put(field.getName(), nestedList);
        }
        updateRequestBuilder.setDoc(source);
        this.logger.debug("update source: {}", source);
        return new EsUpdateBuilderItem(updateRequestBuilder);
    }

    public class EsUpdateBuilderItem
    implements UpdateBuilderItem {
        private final org.elasticsearch.action.update.UpdateRequestBuilder updateRequestBuilder;

        public EsUpdateBuilderItem(org.elasticsearch.action.update.UpdateRequestBuilder updateRequestBuilder) {
            this.updateRequestBuilder = updateRequestBuilder;
        }

        public org.elasticsearch.action.update.UpdateRequestBuilder getUpdateRequestBuilder() {
            return this.updateRequestBuilder;
        }

        @Override
        public String get() {
            return String.valueOf(((UpdateResponse)this.updateRequestBuilder.get()).getResult());
        }
    }
}

