/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.dubboFilter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.ohaotian.plugin.base.bo.ReqInfo;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class DubboServiceFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DubboServiceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = null;
        Long takeTime = 0L;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            Object[] arguments = invocation.getArguments();
            Arrays.stream(arguments).forEach(n -> {
                if (n instanceof ReqInfo) {
                    ReqInfo req = (ReqInfo)n;
                    BeanMapper.copy((Object)userInfo, (Object)req);
                }
            });
        }
        Long startTime = System.currentTimeMillis();
        result = invoker.invoke(invocation);
        takeTime = System.currentTimeMillis() - startTime;
        logger.info("dubbo:invocation.getMethodName()  \u670d\u52a1\u8fd0\u884c\u65f6\u95f4" + takeTime);
        return result;
    }
}

