/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.service;

import com.ohaotian.plugin.security.property.FilterStaticConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

@Component
public class CasInvocationSecurityMetadataSourceService
implements FilterInvocationSecurityMetadataSource {
    @Autowired
    private FilterStaticConfig filterStaticConfig;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Set<Pattern> getUnLoginUrl() {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        this.filterStaticConfig.getResources().forEach(url -> {
            String regex = url.replace("**", "*").replace("*", ".*");
            patterns.add(Pattern.compile(regex));
        });
        return patterns;
    }

    public Collection<ConfigAttribute> loadResourceDefine(String url) {
        ArrayList<ConfigAttribute> array = new ArrayList<ConfigAttribute>();
        array.add((ConfigAttribute)new SecurityConfig(url));
        return array;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String url = request.getRequestURI();
        url = url.replaceFirst(request.getContextPath(), "");
        this.logger.info(url);
        Set<Pattern> patterns = this.getUnLoginUrl();
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            return null;
        }
        return this.loadResourceDefine(url);
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

