/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import com.ohaotian.plugin.security.filter.Ajax401Filter;
import com.ohaotian.plugin.security.property.AppServerConfig;
import com.ohaotian.plugin.security.property.CasServerConfig;
import com.ohaotian.plugin.security.service.DefaultUserDetailsService;
import java.util.EventListener;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationEntryPoint;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;

@Configuration
public class CasConfiguration {
    @Autowired
    private CasServerConfig casServerConfig;
    @Autowired
    private AppServerConfig appServerConfig;
    @Autowired
    private UserDetailsService userDetailsService;

    @Bean
    public ServiceProperties serviceProperties() {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(this.appServerConfig.getUrl() + "/login/cas");
        serviceProperties.setAuthenticateAllArtifacts(true);
        return serviceProperties;
    }

    @Bean
    public Cas20ServiceTicketValidator cas20ServiceTicketValidator() {
        return new Cas20ServiceTicketValidator(this.casServerConfig.getIntranet());
    }

    @Bean
    public SingleSignOutFilter singleSignOutFilter() {
        SingleSignOutFilter outFilter = new SingleSignOutFilter();
        outFilter.setCasServerUrlPrefix(this.casServerConfig.getOuter());
        outFilter.setIgnoreInitConfiguration(true);
        return outFilter;
    }

    @Bean
    public LogoutFilter logoutFilter() {
        LogoutFilter logoutFilter = new LogoutFilter(this.casServerConfig.getLogout(), new LogoutHandler[]{new SecurityContextLogoutHandler()});
        logoutFilter.setFilterProcessesUrl("/logout");
        return logoutFilter;
    }

    @Bean
    public Ajax401Filter ajax401Filter() {
        return new Ajax401Filter();
    }

    @Bean(value={"casProvider"})
    public CasAuthenticationProvider casAuthenticationProvider() {
        CasAuthenticationProvider provider = new CasAuthenticationProvider();
        provider.setKey("casProvider");
        provider.setServiceProperties(this.serviceProperties());
        provider.setTicketValidator((TicketValidator)this.cas20ServiceTicketValidator());
        provider.setUserDetailsService(this.userDetailsService);
        return provider;
    }

    @Bean
    public UserDetailsService userDetailsService() {
        if (this.userDetailsService != null) {
            return this.userDetailsService;
        }
        return new DefaultUserDetailsService();
    }

    @Bean
    public CasAuthenticationEntryPoint casAuthenticationEntryPoint() {
        CasAuthenticationEntryPoint entryPoint = new CasAuthenticationEntryPoint();
        entryPoint.setServiceProperties(this.serviceProperties());
        entryPoint.setLoginUrl(this.casServerConfig.getLogin());
        return entryPoint;
    }

    @Bean
    public SwitchUserFilter switchUserFilter(UserDetailsService userDetailsService) throws Exception {
        SwitchUserFilter switchUserFilter = new SwitchUserFilter();
        switchUserFilter.setUserDetailsService(userDetailsService);
        switchUserFilter.setUsernameParameter("userId");
        switchUserFilter.setTargetUrl(this.appServerConfig.getIndex());
        switchUserFilter.setSwitchUserUrl("/switch");
        return switchUserFilter;
    }

    @Bean
    public ServletListenerRegistrationBean servletListenerRegistrationBean() {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean();
        servletListenerRegistrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        return servletListenerRegistrationBean;
    }
}

