/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.ohaotian.plugin.security.entity.UserInfo;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String token = request.getHeader("auth-token");
        if (!"123".equals(token)) {
            return null;
        }
        UserInfo user = new UserInfo();
        user.setUserId(1L);
        return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Authentication auth = null;
        allowSessionCreation.set(true);
        if (request.getHeader("auth-token") != null) {
            auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                response.sendError(401, "Token \u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7 token");
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

