/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.jwt.TokenState;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private static ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String token = request.getHeader("auth-token");
        if ("123".equals(token)) {
            UserInfo user = new UserInfo();
            return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        }
        Map<String, Object> resultMap = Jwt.validToken(token);
        TokenState state = TokenState.getTokenState((String)resultMap.get("state"));
        JSONObject jsonObject = new JSONObject();
        switch (state) {
            case VALID: {
                request.setAttribute("data", resultMap.get("data"));
                UserInfo user = new UserInfo();
                return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            }
            case EXPIRED: {
                jsonObject.put("MESSAGE", (Object)"Token \u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7 token");
                break;
            }
            default: {
                jsonObject.put("MESSAGE", (Object)"Token \u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7 token");
            }
        }
        response.setStatus(401);
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("result", (Object)"unLogin");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        allowSessionCreation.set(true);
        if (request.getHeader("auth-token") != null) {
            Authentication auth = this.attemptAuthentication(request, response);
            if (auth == null) {
                return;
            }
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

