package com.ohaotian.plugin.security.property;


import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Component
public class FilterStaticConfig {


    private Set<String> resources = new HashSet<>();


    @Value("${static.resources}")
    private String staticRes;

    public Set<String> getResources() {
        if (StringUtils.isNoneBlank(staticRes)) {
            String[] split = staticRes.split(";");
            for (String res : split) {
                resources.add(res);
            }
        }
        return resources;
    }

    public void setStaticRes(String staticRes) {
        this.staticRes = staticRes;
    }
}
