package com.ohaotian.plugin.security.entity;

import com.ohaotian.plugin.security.constants.SercurityConstants;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.*;


/**
 * 用户信息
 *
 * @author liubq
 */
public class UserInfo implements UserDetails {

    private static final long serialVersionUID = -7580618077423166554L;
    /**
     * 用户id
     */
    private Long userId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 用户组织机构路径
     */
    private String orgPath;

    /**
     * 组织机构编码
     */
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 手机号
     */
    private String cellphone;


    /**
     * 非结构化菜单数据
     */
    private Set<MenuInfo> unstructuredMunes = new HashSet<>();

    private boolean isAccountNonExpired = true;

    private boolean isAccountNonLocked = true;

    private boolean isCredentialsNonExpired = true;

    private boolean isEnabled = true;

    private Set<AuthorityInfo> permission = new HashSet<>();

    /**
     * 用户拥有的菜单
     */
    private Map<String, List<MenuInfo>> menus = new HashMap<>();

    /**
     * 用户不能访问的拥有的菜单
     */
    private List<MenuInfo> unMenus = new LinkedList<>();


    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        List<GrantedAuthority> auths = new ArrayList<>();
        //获取用户授权能访问的url集合
        this.unstructuredMunes.forEach(menuInfo -> {
            auths.add(new SimpleGrantedAuthority(SercurityConstants.PREFIX + menuInfo.getUrl()));
        });
        return auths;
    }


    private static final ThreadLocal<AuthorityInfo> AUTHORITY_CONTEXT = new ThreadLocal<AuthorityInfo>() {
        @Override
        protected AuthorityInfo initialValue() {
            return new AuthorityInfo();
        }
    };

    public boolean hasAuthority(String authority) {
        if (authority == null) {
            return false;
        }
        AuthorityInfo authorityInfo = AUTHORITY_CONTEXT.get();
        authorityInfo.setKey(authority);
        return this.permission.contains(authorityInfo);
    }

    public void setUnstructuredMunes(List<MenuInfo> unstructuredMunes) {
        this.unstructuredMunes.addAll(unstructuredMunes);
    }


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAccountNonExpired() {
        return isAccountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        isAccountNonExpired = accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return isAccountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        isAccountNonLocked = accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return isCredentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        isCredentialsNonExpired = credentialsNonExpired;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    public void setPermission(Set<AuthorityInfo> permission) {
        this.permission = permission;
    }

    public Set<AuthorityInfo> getPermission() {
        return permission;
    }

    public Map<String, List<MenuInfo>> getMenus() {
        return menus;
    }

    public void setMenus(Map<String, List<MenuInfo>> menus) {
        this.menus = menus;
    }

    public List<MenuInfo> getUnMenus() {
        return unMenus;
    }

    public void setUnMenus(List<MenuInfo> unMenus) {
        this.unMenus = unMenus;
    }

    public String getOrgPath() {
        return orgPath;
    }

    public void setOrgPath(String orgPath) {
        this.orgPath = orgPath;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCellphone() {
        return cellphone;
    }

    public void setCellphone(String cellphone) {
        this.cellphone = cellphone;
    }


    @Override
    public String toString() {
        return "UserInfo{" +
                "userId=" + userId +
                ", name='" + name + '\'' +
                ", username='" + username + '\'' +
                ", password='" + password + '\'' +
                ", orgPath='" + orgPath + '\'' +
                ", orgId=" + orgId +
                ", orgName='" + orgName + '\'' +
                ", cellphone='" + cellphone + '\'' +
                ", unstructuredMunes=" + unstructuredMunes +
                ", isAccountNonExpired=" + isAccountNonExpired +
                ", isAccountNonLocked=" + isAccountNonLocked +
                ", isCredentialsNonExpired=" + isCredentialsNonExpired +
                ", isEnabled=" + isEnabled +
                ", permission=" + permission +
                ", menus=" + menus +
                ", unMenus=" + unMenus +
                '}';
    }
}
