package com.ohaotian.plugin.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.security.constants.SercurityConstants;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.springframework.web.filter.GenericFilterBean;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * ajax访问
 * 当用户没有登录时，访问受保护资源时，返回HTTP状态码401
 * 当访问请求中包含SercurityConstants.SIGNUO时，说明该请求不许登录，即可访问
 */
public class Ajax401Filter extends GenericFilterBean {
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        final HttpServletRequest request = (HttpServletRequest) servletRequest;
        final HttpServletResponse response = (HttpServletResponse) servletResponse;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        StringBuffer requestURL = request.getRequestURL();
        String url = requestURL.toString();
        if (userInfo == null && !url.contains(SercurityConstants.SIGNUO) && !url.contains(SercurityConstants.DEMO)) {
            if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {


                response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();

                JSONObject jsonObject = new JSONObject();
                jsonObject.put("result", SercurityConstants.UNLOGIN);
                jsonObject.put("MESSAGE", "请先登录");
                String jsonString = JSON.toJSONString(jsonObject, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty);

                out.write(jsonString);
                out.close();
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}
