package com.ohaotian.plugin.security.config;

import com.ohaotian.plugin.security.constants.SercurityConstants;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Iterator;

@Component
public class CasAccessDecisionManager implements AccessDecisionManager {

    /**
     * @param authentication   当前用户权限信息
     * @param o                请求信息
     * @param configAttributes 当前访问的url对应的角色
     */
    @Override
    public void decide(Authentication authentication, Object o, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        //没有角色要求则返回

        if (null == configAttributes || configAttributes.size() <= 0) {
            return;
        }
        //比较当前用户是否可以访问当前的url对应的角色，是否拥有对应权限
        ConfigAttribute c;
        String needUrl;
        for (Iterator<ConfigAttribute> iter = configAttributes.iterator(); iter.hasNext(); ) {
            c = iter.next();
            needUrl = c.getAttribute();
            boolean flag = true;
            for (GrantedAuthority ga : authentication.getAuthorities()) { //authentication 为在注释1 中循环添加到 GrantedAuthority 对象中的权限信息集合
                if ((SercurityConstants.PREFIX + needUrl.trim()).contains(ga.getAuthority())) {
                    flag = false;
                }
            }
            if (flag) {
                throw new AccessDeniedException("无权限访问，请联系管理员");
            }
        }
        return;
    }

    @Override
    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    @Override
    public boolean supports(Class<?> aClass) {
        return true;
    }
}