package com.ohaotian.plugin.security.dubboFilter;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.ohaotian.plugin.base.bo.ReqInfo;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

@Activate(group = Constants.CONSUMER)
public class DubboServiceFilter implements Filter {

    private final static Logger logger = LoggerFactory.getLogger(DubboServiceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = null;
        Long takeTime = 0L;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            Object[] arguments = invocation.getArguments();
            Arrays.stream(arguments).forEach(n -> {
                if (n instanceof ReqInfo) {
                    ReqInfo req = (ReqInfo) n;
                    BeanMapper.copy(userInfo, req);
                }
            });
        }
        Long startTime = System.currentTimeMillis();

        result = invoker.invoke(invocation);

        takeTime = System.currentTimeMillis() - startTime;


        logger.info("dubbo:invocation.getMethodName() " + " 服务运行时间" + takeTime);
        return result;
    }
}