package com.ohaotian.plugin.security.property;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CasServerConfig {

    @Value("${cas.server.host.outer}")
    private String outer;

    @Value("${cas.server.host.intranet}")
    private String intranet;

    @Value("${cas.server.host.login}")
    private String login;

    @Value("${cas.server.host.logout}")
    private String logout;

    public String getOuter() {
        if (StringUtils.isNoneBlank(outer) && outer.endsWith("/")) {
            outer = outer.substring(0, outer.length() - 1);
        }
        return outer;
    }

    public void setOuter(String outer) {
        this.outer = outer;
    }

    public String getIntranet() {
        if (StringUtils.isNoneBlank(intranet) && intranet.endsWith("/")) {
            intranet = intranet.substring(0, intranet.length() - 1);
        }
        return intranet;
    }

    public void setIntranet(String intranet) {
        this.intranet = intranet;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogout() {
        return logout;
    }

    public void setLogout(String logout) {
        this.logout = logout;
    }
}
