package com.ohaotian.plugin.uuid.security.service;

import com.ohaotian.plugin.uuid.security.entity.AuthorityInfo;
import com.ohaotian.plugin.uuid.security.entity.MenuInfo;
import com.ohaotian.plugin.uuid.security.entity.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

import java.util.*;
public class DefaultUserDetailsService implements UserDetailsService {

    private final static Logger log = LoggerFactory.getLogger(DefaultUserDetailsService.class);

    @Override
    public UserDetails loadUserByUsername(String userId) throws UsernameNotFoundException {
        UserInfo userInfo = new UserInfo();
        try {
            loadUserMenus(userInfo);
            loadUserAuthoritys(userInfo);
            return userInfo;
        } catch (Exception e) {
            log.error("", e);
            throw new RuntimeException(e);
        }

    }

    /**
     * 获取菜单权限集合
     *
     * @param userInfo
     */
    private void loadUserMenus(UserInfo userInfo) {
        Map<String, List<MenuInfo>> menuMap = new HashMap<>();
        userInfo.setMenus(menuMap);

    }

    /**
     * 获取功能权限集合
     *
     * @param userInfo
     */
    private void loadUserAuthoritys(UserInfo userInfo) {
        Set<AuthorityInfo> authorities = new HashSet<>();
        userInfo.setPermission(authorities);
    }


}
