/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.uuid.security.config;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class ZTCasAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private ServiceProperties serviceProperties;
    private String loginUrl;
    private boolean encodeServiceUrlWithSessionId = true;
    public static final String LOGIN_TYPE_COLUMN_MODE = "mode";
    public static final String DEFAULT_MODE = "1";
    private String mode = "1";

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.loginUrl, (String)"loginUrl must be specified");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties must be specified");
        Assert.notNull((Object)this.serviceProperties.getService(), (String)"serviceProperties.getService() cannot be null.");
    }

    public final void commence(HttpServletRequest servletRequest, HttpServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        this.preCommence(servletRequest, response);
        String urlEncodedService = this.createServiceUrl(servletRequest, response);
        String redirectUrl = this.createRedirectUrl(urlEncodedService);
        response.sendRedirect(redirectUrl);
    }

    protected String createServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl((HttpServletRequest)null, (HttpServletResponse)response, (String)this.serviceProperties.getService(), (String)null, (String)this.serviceProperties.getArtifactParameter(), (boolean)this.encodeServiceUrlWithSessionId);
    }

    protected String createRedirectUrl(String serviceUrl) {
        CommonUtils.constructRedirectUrl((String)this.getLoginUrl(), (String)this.getServiceProperties().getServiceParameter(), (String)serviceUrl, (boolean)this.getServiceProperties().isSendRenew(), (boolean)false);
        String url = CommonUtils.constructRedirectUrl((String)this.loginUrl, (String)this.serviceProperties.getServiceParameter(), (String)serviceUrl, (boolean)this.serviceProperties.isSendRenew(), (boolean)false);
        return StringUtils.join((Object[])new String[]{url, "&mode=", this.mode});
    }

    protected void preCommence(HttpServletRequest request, HttpServletResponse response) {
        String newMode = request.getParameter(LOGIN_TYPE_COLUMN_MODE);
        if (StringUtils.isBlank((CharSequence)newMode)) {
            Object objMode = request.getAttribute(LOGIN_TYPE_COLUMN_MODE);
            newMode = objMode == null ? null : objMode.toString();
        }
        this.setMode(StringUtils.isNotBlank((CharSequence)newMode) ? newMode : DEFAULT_MODE);
    }

    public final String getLoginUrl() {
        return this.loginUrl;
    }

    public final ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public final void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public final void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public final void setEncodeServiceUrlWithSessionId(boolean encodeServiceUrlWithSessionId) {
        this.encodeServiceUrlWithSessionId = encodeServiceUrlWithSessionId;
    }

    protected boolean getEncodeServiceUrlWithSessionId() {
        return this.encodeServiceUrlWithSessionId;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

