/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.auth;

import com.ohaotian.plugin.common.util.RegUtils;
import java.util.Collection;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class CasAccessDecisionManager
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object o, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (null == configAttributes || configAttributes.size() <= 0) {
            return;
        }
        for (ConfigAttribute c : configAttributes) {
            String needUrl = c.getAttribute();
            boolean flag = authentication.getAuthorities().stream().map(ga -> ga.getAuthority()).anyMatch(authUrl -> needUrl.trim().contains((CharSequence)authUrl) || RegUtils.match((String)authUrl, (String)needUrl.trim()));
            if (flag || !RegUtils.match((String)"**.html", (String)needUrl.trim())) continue;
            throw new AccessDeniedException("\u65e0\u6743\u9650\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> aClass) {
        return true;
    }
}

