/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config;

import com.ohaotian.cas.SingleSignOutFilter;
import com.ohaotian.plugin.security.auth.XHttpSessionSecurityContextRepository;
import com.ohaotian.plugin.security.config.ZTCasAuthenticationEntryPoint;
import com.ohaotian.plugin.security.filter.Ajax401Filter;
import com.ohaotian.plugin.security.filter.TokenAuthenticationFilter;
import com.ohaotian.plugin.security.interceptor.CasFilterSecurityInterceptor;
import com.ohaotian.plugin.security.property.FilterStaticConfig;
import java.util.EventListener;
import javax.servlet.Filter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.context.SecurityContextRepository;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Value(value="${cas.server.host.outer}")
    private String casUrl;
    @Value(value="${app.server.host.url}")
    private String appUrl;
    @Autowired
    private CasFilterSecurityInterceptor myFilterSecurityInterceptor;
    @Autowired
    private FilterStaticConfig filterStaticConfig;

    public void configure(WebSecurity web) throws Exception {
        this.filterStaticConfig.getResources().forEach(resource -> {
            try {
                web.ignoring().antMatchers(new String[]{resource});
            }
            catch (Exception e) {
                log.error("\u767d\u540d\u5355\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        });
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.headers().frameOptions().disable();
        http.csrf().disable();
        http.securityContext().securityContextRepository((SecurityContextRepository)new XHttpSessionSecurityContextRepository());
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/**/users/signup/**"})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        http.logout().permitAll();
        ZTCasAuthenticationEntryPoint entryPoint = (ZTCasAuthenticationEntryPoint)this.getApplicationContext().getBean(ZTCasAuthenticationEntryPoint.class);
        CasAuthenticationFilter casAuthenticationFilter = (CasAuthenticationFilter)this.getApplicationContext().getBean(CasAuthenticationFilter.class);
        SingleSignOutFilter singleSignOutFilter = (SingleSignOutFilter)this.getApplicationContext().getBean(SingleSignOutFilter.class);
        LogoutFilter logoutFilter = (LogoutFilter)this.getApplicationContext().getBean(LogoutFilter.class);
        Ajax401Filter ajax401Filter = (Ajax401Filter)((Object)this.getApplicationContext().getBean(Ajax401Filter.class));
        SwitchUserFilter switchUserFilter = (SwitchUserFilter)this.getApplicationContext().getBean(SwitchUserFilter.class);
        TokenAuthenticationFilter tokenAuthenticationFilter = (TokenAuthenticationFilter)((Object)this.getApplicationContext().getBean(TokenAuthenticationFilter.class));
        ((HttpSecurity)http.addFilterAfter((Filter)switchUserFilter, FilterSecurityInterceptor.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)entryPoint).and()).addFilter((Filter)casAuthenticationFilter).addFilterBefore((Filter)logoutFilter, LogoutFilter.class).addFilterBefore((Filter)singleSignOutFilter, CasAuthenticationFilter.class).addFilterBefore((Filter)ajax401Filter, CasAuthenticationFilter.class).addFilterBefore((Filter)this.myFilterSecurityInterceptor, FilterSecurityInterceptor.class).addFilterBefore((Filter)tokenAuthenticationFilter, UsernamePasswordAuthenticationFilter.class);
        http.antMatcher("/**");
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        AuthenticationProvider authenticationProvider = (AuthenticationProvider)this.getApplicationContext().getBean("casProvider");
        auth.authenticationProvider(authenticationProvider);
    }

    @Bean
    public ServletListenerRegistrationBean<SingleSignOutHttpSessionListener> singleSignOutHttpSessionListener() {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean();
        servletListenerRegistrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        return servletListenerRegistrationBean;
    }

    @Bean
    public CasAuthenticationFilter casAuthenticationFilter(ServiceProperties properties) throws Exception {
        CasAuthenticationFilter casAuthenticationFilter = new CasAuthenticationFilter();
        casAuthenticationFilter.setServiceProperties(properties);
        casAuthenticationFilter.setFilterProcessesUrl("/login/cas");
        casAuthenticationFilter.setAuthenticationManager(this.authenticationManager());
        casAuthenticationFilter.setContinueChainBeforeSuccessfulAuthentication(false);
        return casAuthenticationFilter;
    }
}

