package com.ohaotian.plugin.security.service;

import com.ohaotian.plugin.security.property.FilterStaticConfig;
import com.ohaotian.plugin.security.utils.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.regex.Pattern;

@Component
public class CasInvocationSecurityMetadataSourceService implements FilterInvocationSecurityMetadataSource {

    private final static Logger log = LoggerFactory.getLogger(CasInvocationSecurityMetadataSourceService.class);



    @Autowired
    private FilterStaticConfig filterStaticConfig;



    /**
     * 查找url对应的角色
     */
    public Collection<ConfigAttribute> loadResourceDefine(String url) {
        //此处只添加了用户的，其实还可以添加更多权限的信息，例如请求方法到ConfigAttribute的集合中去。此处添加的信息将会作为CasAccessDecisionManager类的decide的第三个参数。
        Collection<ConfigAttribute> array = new ArrayList<>();
        array.add(new SecurityConfig(url));
        return array;
    }

    @Override
    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        //object 中包含用户请求的request 信息
        HttpServletRequest request = ((FilterInvocation) object).getHttpRequest();
        String url = request.getRequestURI();
        url = url.replaceFirst(request.getContextPath(), "");
        log.info(url);

        //将请求的url与配置文件中不需要访问控制的url进行匹配
        boolean b = wildcardEquals(url);
        if (b) {
            return null;
        }
        return loadResourceDefine(url);
    }


    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    @Override
    public boolean supports(Class<?> aClass) {
        return true;
    }


    /**
     * 通配符模式
     *
     * @param reqPath - 请求地址
     * @return
     */
    private boolean wildcardEquals(String reqPath) {
        //可通过配置过滤路径，这里就省略不写了，写法与AcmCasProperties一致
        for (String url : filterStaticConfig.getResources()) {
            String regex = url.replace("**", "*").replace("*", ".*");
            String regPath = RegexUtils.getRegPath(regex);
            if (Pattern.compile(regPath).matcher(reqPath).matches()) {
                return true;
            }
        }
        return false;
    }

}
