/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.security.config.ZTCasAuthenticationEntryPoint;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.property.AppServerConfig;
import com.ohaotian.plugin.security.utils.RegexUtils;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.cas.web.CasAuthenticationFilter;
import org.springframework.web.filter.GenericFilterBean;

public class Ajax401Filter
extends GenericFilterBean {
    @Autowired
    private AppServerConfig appServerConfig;
    @Autowired
    private CasAuthenticationFilter casAuthenticationFilter;
    @Autowired
    private ServiceProperties serviceProperties;
    @Autowired
    private CasAuthenticationProvider casAuthenticationProvider;
    @Autowired
    private ZTCasAuthenticationEntryPoint zTCasAuthenticationEntryPoint;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        StringBuffer requestURL = request.getRequestURL();
        String url = requestURL.toString();
        String reqUri = request.getRequestURI();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
            reqUri = reqUri.substring(0, reqUri.length() - 1);
        }
        String suffix = "/login/cas";
        if (userInfo == null && !Ajax401Filter.wildcardEquals("**/**/users/signup/**", url)) {
            if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
                response.setStatus(401);
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("result", (Object)"unLogin");
                jsonObject.put("MESSAGE", (Object)"\u8bf7\u5148\u767b\u5f55");
                String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
                out.write(jsonString);
                out.close();
                return;
            }
            if (url.endsWith(suffix)) {
                suffix = "";
            }
            url = url + suffix;
            reqUri = reqUri + suffix;
        } else {
            url = this.appServerConfig.getUrl() + "/login/cas";
            reqUri = "/login/cas";
        }
        this.logger.info((Object)("url=" + url));
        this.serviceProperties.setService(url);
        this.casAuthenticationFilter.setServiceProperties(this.serviceProperties);
        this.casAuthenticationFilter.setFilterProcessesUrl(reqUri);
        this.casAuthenticationProvider.setServiceProperties(this.serviceProperties);
        this.zTCasAuthenticationEntryPoint.setServiceProperties(this.serviceProperties);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private static boolean wildcardEquals(String whitePath, String reqPath) {
        String regPath = RegexUtils.getRegPath(whitePath);
        return Pattern.compile(regPath).matcher(reqPath).matches();
    }
}

