package com.ohaotian.plugin.security.property;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppServerConfig {

    @Value("${app.server.host.url}")
    private String url;

    @Value("${app.server.host.index}")
    private String index;


    public String getUrl() {
        if (StringUtils.isNoneBlank(url) && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIndex() {
        return index;
    }

    public void setIndex(String index) {
        this.index = index;
    }
}
