package com.ohaotian.plugin.session;

import org.springframework.session.ExpiringSession;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
public class CacheSession implements ExpiringSession, Serializable {

    private static final long serialVersionUID = 3024506719282139459L;
    /**
     * session id
     */
    private String id;
    /**
     * 属性
     */
    private Map<String, Object> attributes;
    /**
     * 创建时间
     */
    private long creationTime;
    /**
     * 上一次操作时间
     */
    private long lastAccessedTime;

    private boolean isNew;


    public CacheSession() {
        this("ZT-" + UUID.randomUUID().toString());
    }

    public CacheSession(String id) {
        this.id = id;
        this.attributes = new HashMap();
        this.creationTime = System.currentTimeMillis();
        this.lastAccessedTime = this.creationTime;
        this.isNew = true;
    }

    public CacheSession(ExpiringSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.attributes = new HashMap(session.getAttributeNames().size());
        session.getAttributeNames().forEach(attrName -> {
            Object attrValue = session.getAttribute(attrName);
            this.attributes.put(attrName, attrValue);
        });
        this.lastAccessedTime = session.getLastAccessedTime();
        this.creationTime = session.getCreationTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public long getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return lastAccessedTime;
    }

    @Override
    public void setMaxInactiveIntervalInSeconds(int i) {

    }

    @Override
    public int getMaxInactiveIntervalInSeconds() {
        return 0;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }


    public Map<String, Object> getAttributes() {
        return attributes;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        return (T) attributes.get(attributeName);
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            removeAttribute(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
        }
        this.isNew = true;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isNew() {
        return isNew;
    }

    public void setNew(boolean aNew) {
        isNew = aNew;
    }
}
