package com.ohaotian.plugin.session;

import com.ohaotian.plugin.cache.CacheTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.session.SessionRepository;

/**
 * @author liubq
 */
public class CacheSessionRepository implements SessionRepository<CacheSession> {

    private final static Logger log = LoggerFactory.getLogger(CacheSessionRepository.class);


    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();

    private final static String REGION = "ZT-SESSIONID";

    @Override
    public CacheSession createSession() {
        CacheSession session = new CacheSession();
        return session;
    }

    @Override
    public void save(CacheSession session) {
        if (session == null){
            return;
        }
        if (session.isNew()) {
            session.setNew(false);
            cacheTemplate.set(getSessionId(session.getId()), session);
        }
    }

    @Override
    public CacheSession getSession(String id) {
        log.info("ZTSESSIONID:{}",id);
        Object o = cacheTemplate.get(getSessionId(id));
        if (o instanceof CacheSession) {
            CacheSession session = (CacheSession) o;
            log.info(o.toString());
            log.info(session.getCreationTime() + " " + session.getLastAccessedTime() + " " + session.getCreationTime());
            return session;
        }
        return null;

    }

    @Override
    public void delete(String id) {
        CacheSession session = getSession(id);
        if (session == null){
            return;
        }
        cacheTemplate.del(getSessionId(id));
    }

    private String getSessionId(String id) {
        return REGION + ":" + id;
    }


}
