/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.CacheTemplate;
import com.ohaotian.plugin.cache.CaffeineCache;
import com.ohaotian.plugin.constant.SessionConstant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CacheConfig {
    private static final Logger log = LoggerFactory.getLogger(CacheConfig.class);
    @Resource
    private SessionConstant sessionConstant;
    @Resource
    private CacheClient redisCache;

    @Bean
    public CaffeineCache init() {
        CaffeineCache caffeineCache = this.buildCache();
        CacheTemplate cacheTemplate = CacheTemplate.getIstance();
        cacheTemplate.init(caffeineCache, this.redisCache, this.sessionConstant);
        return caffeineCache;
    }

    public CaffeineCache buildCache() {
        Cache loadingCache = Caffeine.newBuilder().maximumSize(this.sessionConstant.getCaffeineSize().longValue()).expireAfterWrite(this.sessionConstant.getDefaultMaxInactiveIntervalCaffeine().longValue(), TimeUnit.SECONDS).removalListener((key, value, cause) -> {
            if (cause != RemovalCause.EXPLICIT && cause != RemovalCause.REPLACED) {
                log.info("removal listerner called with key [%s], cause [%s], evicted [%S] size [%s], expire [%s]\n", new Object[]{key, cause.toString(), cause.wasEvicted(), this.sessionConstant.getCaffeineSize(), this.sessionConstant.getDefaultMaxInactiveIntervalCaffeine()});
            }
        }).build();
        return new CaffeineCache((Cache<String, Object>)loadingCache, this.sessionConstant.getCaffeineSize(), this.sessionConstant.getDefaultMaxInactiveIntervalCaffeine());
    }
}

