/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Random;

public class Command {
    private static final int SRC_ID = Command.genRandomSrc();
    public static final byte OPT_JOIN = 1;
    public static final byte OPT_CLEAR_KEY = 2;
    public static final byte OPT_QUIT = 3;
    private int src = SRC_ID;
    private int operator;
    private String key;

    private static int genRandomSrc() {
        long ct = System.currentTimeMillis();
        Random rndSeed = new Random(ct);
        return (int)((long)(rndSeed.nextInt(10000) * 1000) + ct % 1000L);
    }

    public Command() {
    }

    public Command(byte o, String key) {
        this.operator = o;
        this.key = key;
    }

    public static Command join() {
        return new Command(1, null);
    }

    public static Command quit() {
        return new Command(3, null);
    }

    public String json() {
        return JSON.toJSONString((Object)this);
    }

    public byte[] jsonBytes() {
        return this.json().getBytes();
    }

    public static Command parse(String json) {
        return (Command)JSON.parseObject((String)json, Command.class);
    }

    public static Command parse(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return Command.parse(new String(bytes));
    }

    @JSONField(serialize=false)
    public boolean isLocal() {
        return this.src == SRC_ID;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getSrc() {
        return this.src;
    }

    public void setSrc(int src) {
        this.src = src;
    }
}

