package com.ohaotian.plugin.cache;

import com.github.benmanes.caffeine.cache.Cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

/**
 * Caffeine cache
 *
 * @author  liubinqi(liubq@tydic.com)
 */
public class CaffeineCache  {

    private Cache<String, Object> cache;
    private long size ;
    private long expire ;

    public CaffeineCache(Cache<String, Object> cache, long size, long expire) {
        this.cache = cache;
        this.size = size;
        this.expire = expire;
    }

    public long ttl() {
        return expire;
    }

    public long size() { return size; }

    public Object get(String key) {
        return cache.getIfPresent(key);
    }

    public Map<String, Object> get(Collection<String> keys) {
        return cache.getAllPresent(keys);
    }

    public void put(String key, Object value) {
        cache.put(key, value);
    }

    public void put(Map<String, Object> elements) {
        cache.putAll(elements);
    }

    public Collection<String> keys() {
        return cache.asMap().keySet();
    }

    public void evict(String...keys) {
        cache.invalidateAll(Arrays.asList(keys));
    }

    public void clear() {
        cache.invalidateAll();
    }
}
