package com.ohaotian.plugin.session;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.session.web.http.SessionRepositoryFilter;

@Configuration
public class CacheSessionConfig {


    @Bean(name = "springSession")
    public SessionRepositoryFilter sessionRepositoryFilter() {
        return new SessionRepositoryFilter(cacheSessionRepository());
    }

    @Bean
    public CacheSessionRepository cacheSessionRepository() {
        return new CacheSessionRepository();
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("JSESSIONID");
        serializer.setCookiePath("/");
        serializer.setDomainNamePattern("^.+?\\.(\\w+\\.[a-z]+)$");
        return serializer;
    }
}
