/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.cache;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.cache.CaffeineCache;
import com.ohaotian.plugin.cache.RedisPubSubClusterPolicy;
import com.ohaotian.plugin.constant.SessionConstant;

public class CacheTemplate {
    private static volatile CacheTemplate INSTANCE;
    private static CaffeineCache CAFFEINECACHE;
    private CacheClient redisCache;
    private SessionConstant sessionConstant;
    private static final RedisPubSubClusterPolicy POLICY;

    private CacheTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheTemplate getIstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<CacheTemplate> clazz = CacheTemplate.class;
        synchronized (CacheTemplate.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CacheTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected void init(CaffeineCache caffeineCache, CacheClient redisCache, SessionConstant sessionConstant) {
        CAFFEINECACHE = caffeineCache;
        this.redisCache = redisCache;
        this.sessionConstant = sessionConstant;
        boolean isCluster = redisCache.isCluster();
        POLICY.setCluster(isCluster);
        if (isCluster) {
            POLICY.connect(redisCache.getJedisCluster());
        } else {
            POLICY.connect(redisCache.getJedisPool());
        }
    }

    public void set(String key, Object value) {
        try {
            CAFFEINECACHE.put(key, value);
            this.redisCache.set(key, value, this.sessionConstant.getDefaultMaxInactiveIntervalReids().intValue());
        }
        finally {
            POLICY.sendClearCmd(key);
        }
    }

    public Object get(String key) {
        Object level1Value = CAFFEINECACHE.get(key);
        if (level1Value != null) {
            return level1Value;
        }
        Object level2Value = this.redisCache.get(key);
        if (level2Value != null) {
            CAFFEINECACHE.put(key, level2Value);
            this.redisCache.expire(key, 600);
            return level2Value;
        }
        return null;
    }

    public void del(String key) {
        CAFFEINECACHE.evict(key);
        this.redisCache.delete(key);
        POLICY.sendClearCmd(key);
    }

    public void evict(String key) {
        CAFFEINECACHE.evict(key);
    }

    static {
        POLICY = new RedisPubSubClusterPolicy();
    }
}

