/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.session;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.session.Session;

public class CacheSession
implements Session,
Serializable {
    private static final long serialVersionUID = 3024506719282139459L;
    private String id;
    private Map<String, Object> attributes;
    private Instant creationTime;
    private Instant lastAccessedTime;
    private boolean isNew;

    public CacheSession() {
        this("ZT-" + UUID.randomUUID().toString());
    }

    public CacheSession(String id) {
        this.id = id;
        this.attributes = new HashMap<String, Object>();
        this.lastAccessedTime = this.creationTime = Instant.now();
        this.isNew = true;
    }

    public CacheSession(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.attributes = new HashMap<String, Object>(session.getAttributeNames().size());
        session.getAttributeNames().forEach(attrName -> {
            Object attrValue = session.getAttribute(attrName);
            this.attributes.put((String)attrName, attrValue);
        });
        this.lastAccessedTime = Instant.now();
        this.creationTime = Instant.now();
    }

    public String getId() {
        return this.id;
    }

    public String changeSessionId() {
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public void setLastAccessedTime(Instant instant) {
    }

    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setMaxInactiveInterval(Duration duration) {
    }

    public Duration getMaxInactiveInterval() {
        return null;
    }

    public boolean isExpired() {
        return false;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public <T> T getAttribute(String attributeName) {
        return (T)this.attributes.get(attributeName);
    }

    public <T> T getRequiredAttribute(String name) {
        return null;
    }

    public <T> T getAttributeOrDefault(String name, T defaultValue) {
        return null;
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            this.removeAttribute(attributeName);
        } else {
            this.attributes.put(attributeName, attributeValue);
        }
        this.isNew = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }
}

